<?php
namespace App\Helpers;

class Utils
{

    public static function makeAdsCall(string $verb, string $url, array $curl_options=[], array $post_params=[]): array
    {
        try
        {
            $options = [
                CURLOPT_URL             => $url,
                CURLOPT_RETURNTRANSFER  => $curl_options['CURLOPT_RETURNTRANSFER'] ?? true,
                CURLOPT_ENCODING        => $curl_options['CURLOPT_ENCODING'] ?? '',
                CURLOPT_MAXREDIRS       => $curl_options['CURLOPT_MAXREDIRS'] ?? 10,
                CURLOPT_TIMEOUT         => $curl_options['CURLOPT_TIMEOUT'] ?? 0,
                CURLOPT_FOLLOWLOCATION  => $curl_options['CURLOPT_FOLLOWLOCATION'] ?? true,
                CURLOPT_HTTP_VERSION    => $curl_options['CURLOPT_HTTP_VERSION'] ?? CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST   => strtoupper($verb),
            ];


            $curl_helper = new CurlHelpers($url, $options);
            $response    = $curl_helper->__invoke();
            return ['success'=> true, 'data' => json_decode($response), 'debug-data'=> $curl_helper->returnError()];
        }
        catch(Exception $ex)
        {
            return ['success' => false, 'data'=> [], 'debug-data' => ['message'=> $ex->getMessage()]];
        }

    }
}