<?php

namespace App\Http\Controllers\api\v1;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\api\v1\Country;
use App\Models\api\v1\Role;
use App\Models\api\v1\UserRole;
use App\Models\User;
use Auth;
use Exception;
use Log;
use Carbon\Carbon;
use GuzzleHttp\Client;
use GuzzleHttp\Psr7\Request as Psr7Request;
use Session;
use Illuminate\Support\Facades\DB;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;


class AccountController extends Controller
{
    

    /**
     * Info compte Flex utilisateur
     */
    public function flexInfo(Request $request)
    {
        $wallets[0] = [
            
            "id"=>1,
            "user_id"=> 1,
            "country_payment_mode_id"=> 1,
            "name"=> "Flex",
            "is_active"=> 1,
            "created_at"=> "2023-12-24T11:39:37.000000Z",
            "created_by"=> null,
            "updated_by"=> null,
            "updated_at"=> "2023-12-24T11:39:37.000000Z",
            "is_deleted"=> 0,
            "deleted_at"=> null,
            "deleted_by"=> null,
            "user"=>[
                "id"=> 1,
                "uuid"=> "8ab3e74a-68a0-4bf9-90cb-7f0981a30274",
                "gender_id"=> 2,
                "username"=> "0709887766",
                "email"=> null,
                "email_verified_at"=> null,
                "create_time"=> "2023-12-24 11:39:37",
                "lastname"=> "Toure",
                "firstname"=> "Al Badra",
                "phone_code"=> "+225",
                "country_id"=> 1,
                "is_active"=> 1,
            ],
            "countries_payment_modes" =>[
                'id'=> 1, 
                'country_id'=>2, 
                'payment_mode_id'=> 1, 
                'is_active'=> 1, 
                'countries'=> [
                    'id'=>2, 
                    'uuid'=>"9008-00999-00-000",
                    'name'=> "Burkina Faso", 
                    'is_active'=>1, 
                ],
                'payment_modes'=> [
                    'id'=>1, 
                    'uuid'=>"9008-00999-00-000",
                    'name'=> "Flex", 
                    'is_active'=>1, 
                ]
            ]
        
    ];
    $wallets[1] = [
        
        "id"=>1,
        "user_id"=> 1,
        "country_payment_mode_id"=> 2,
        "name"=> "OM",
        "is_active"=> 1,
        "user"=>[
            "id"=> 1,
            "uuid"=> "8ab3e74a-68a0-4bf9-90cb-7f0981a30274",
            "gender_id"=> 2,
            "username"=> "0709887766",
            "email"=> null,
            "email_verified_at"=> null,
            "create_time"=> "2023-12-24 11:39:37",
            "lastname"=> "Toure",
            "firstname"=> "Al Badra",
            "phone_code"=> "+225",
            "country_id"=> 1,
            "is_active"=> 1,
        ],
        "countries_payment_modes" =>[
            'id'=> 2, 
            'country_id'=>2, 
            'payment_mode_id'=> 2, 
            'is_active'=> 1, 
            'countries'=> [
                'id'=>2, 
                'uuid'=>"9008-00999-00-000",
                'name'=> "Burkina Faso", 
                'is_active'=>1, 
            ],
            'payment_modes'=> [
                'id'=>1, 
                'uuid'=>"9008-00999-00-000",
                'name'=> "Orane Money", 
                'is_active'=>1, 
            ]
        ]
    
];
        $data = [ 
                    "flex_info"=>[
                        "id"=> 7,
                        "msisdn"=> "0709887766",
                        "firstname"=> "Jean",
                        "lastname"=> "Valjean",
                        "solde"=> 9500,
                        "is_active"=> 1,
                        "created_at"=> "2023-12-24T11:39:37.000000Z",
                    ],
                    "wallet"=>$wallets
                
                ];
        #reponse
        return response()->json([ 'success' =>true,'message' =>'','data' => $data] , 200);

    }


    /**
     * List ds transaction de l utilisateur
     */
    public function transactionList(Request $request)
    {
        
        $data[0] = [  
            "transactions"=>[
                        "id"=>1,
                        "uuid"=> "4556-8787-89-0091",
                        "order_id"=> null,
                        "subscription_id"=> 1,
                        "transaction_status_id"=> 1,
                        "transaction_type_id"=> 1,
                        "amount_paid"=> 2700,
                        "wallet_id"=> 1,
                        "is_active"=> 1,
                        "order"=>[],
                        'wallet'=> [
                            'id'=>1, 
                            'uuid'=>"9008-00999-00-000",
                            'name'=> "Flex", 
                            'country_payment_mode_id'=>1, 
                            'create_time'=> "2023-12-24T11:39:37.000000Z",
                            'is_active'=>1, 
                        ],
                        'transaction_type'=> [
                            'id'=>1, 
                            'uuid'=>"9008-00999-00-000",
                            'name'=> "payment", 
                            'is_active'=>1, 
                        ],
                        'transaction_status'=> [
                            'id'=>3, 
                            'uuid'=>"9008-00999-00-000",
                            'name'=> "completed", 
                            'step_number'=>3, 
                            'is_active'=>1, 
                        ],
                        "subscritions" =>[
                            'id'=> 1, 
                            'susbcription_status_id'=>2, 
                            'susbcription_type_id'=> 2, 
                            'name'=> 'Souscription Data', 
                            'owned_by'=> null, 
                            'is_active'=> 1, 
                            'susbcription_type'=> [
                                'id'=>1, 
                                'uuid'=>"9008-00999-00-000",
                                'name'=> "Pass 1Hmn", 
                                'is_active'=>1, 
                            ],
                            'subscription_status'=> [
                                'id'=>3, 
                                'uuid'=>"9008-00999-00-000",
                                'name'=> "completed", 
                                'step_number'=>3, 
                                'is_active'=>1, 
                            ],
                        ]
            ]
        ];
        $data[1] = [  
                    "transactions"=>[
                                "id"=>2,
                                "uuid"=> "4556-8787-89-0091",
                                "order_id"=> 1,
                                "subscription_id"=> null,
                                "transaction_status_id"=> 1,
                                "transaction_type_id"=> 1,
                                "amount_paid"=> 2700,
                                "wallet_id"=> 1,
                                "is_active"=> 1,
                                "order"=>[
                                    "id"=> 1,
                                    "uuid"=> "8ab3e74a-68a0-4bf9-90cb-7f0981a30274",
                                    "server_id"=> 2,
                                    "amount_due"=> 3000,
                                    "rebate"=> 10,
                                    "remaining_amount"=> 2700,
                                    "order_status_id"=>2,
                                    "is_active"=> 1,
                                    "server"=>[
                                        "id"=> 1,
                                        "uuid"=> "8ab3e74a-68a0-4bf9-90cb-7f0981a30274",
                                        "gender_id"=> 2,
                                        "country_id"=> 1,
                                        "username"=> "0707080800",
                                        "lastname"=> "Kouame",
                                        "firstname"=> "Marc Alain",
                                        "phone_code"=>"+225",
                                        "is_active"=> 1,
                                    ],
                                    "order_statuses"=>[
                                        "id"=>1, 
                                        "uuid"=>"8ab3e74a-68a0-4bf9-90cb-7f0981a30274", 
                                        "name"=>"Achat", 
                                        "step_number"=>3,
                                        "is_active"=> 1,
                                    ]
                                    
                                ],
                                'transaction_type'=> [
                                    'id'=>1, 
                                    'uuid'=>"9008-00999-00-000",
                                    'name'=> "payment", 
                                    'is_active'=>1, 
                                ],
                                'transaction_status'=> [
                                    'id'=>3, 
                                    'uuid'=>"9008-00999-00-000",
                                    'name'=> "completed", 
                                    'step_number'=>3, 
                                    'is_active'=>1, 
                                ],
                                "subscritions" =>[],
                                
                    ]
                ];

        return response()->json([ 'success' =>true,'message' =>'','data' => $data] , 200);
    }



    /**
     * add bank
     */
    public function addBank(Request $request) : JsonResponse
    {
        //validation
        $validator = Validator::make(
            $request->all(),
            [
                'name' => 'required',
                'bank_code' => 'required|numeric',
                'box_code' => 'required|numeric',
                'account_number' => 'required',
                'rib_key' => 'required|numeric',
            ],
            
                
        );
        //si erreur
        if($validator->fails()){
            return  response(['code'=>201,'success'=>false,'data'=>['name' =>$request->name,'bank_code' =>$request->bank_code,'box_code' =>$request->box_code,'account_number' =>$request->account_number,'rib_key' =>$request->rib_key]],201);
        }
        return response()->json(['code' => 403, 'success' =>false, 'message'=>"Solde insuffisant"] , 403);

    }


    public function walletsInfo(Request $request): JsonResponse
    {
        $data = [
            [ "id"=> 7,
                "msisdn"=> "0707070709",
                "firstname"=> "John",
                "lastname"=> "Doe",
                "solde"=> 9500,
                "is_active"=> 1,
                "created_at"=> "2023-12-24T11:39:37.000000Z"
            ]
        ];

        return $this->ReturnResponse(true, "Wallet Information", $data);
    }

    public function fundByBank(Request $request): JsonResponse
    {
        $data = [
            [ "id"=> 7,
                "msisdn"=> "0707070709",
                "firstname"=> "John",
                "lastname"=> "Doe",
                "solde"=> 20000,
                "is_active"=> 1,
                "created_at"=> "2023-12-24T11:39:37.000000Z"
            ]
        ];

        return $this->ReturnResponse(true, "Wallet Successfully Funded", $data);
    }

    public function fundByMobileMoney(Request $request): JsonResponse
    {
        $data = [
            [ "id"=> 7,
                "msisdn"=> "0707070709",
                "firstname"=> "John",
                "lastname"=> "Doe",
                "solde"=> 20000,
                "is_active"=> 1,
                "created_at"=> "2023-12-24T11:39:37.000000Z"
            ]
        ];

        return $this->ReturnResponse(true, "Wallet Successfully Funded", $data);
    }

}
