<?php

namespace App\Http\Controllers\api\v1;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Route;
use App\Models\api\v1\Role;


class RoleController extends Controller
{


    /**
     * List endpoint
     */
    public function list(Request $request)
    {
        $roles = Role::where([["is_deleted", 0]])->get();

        $results = [];
        foreach ($roles as $role)
        {
            $results[] = [
                "id"            => $role->id,
                "name"          => $role->name,
                "is_active"     => $role->is_active == 1
            ];
        }
        return $this->ReturnResponse(true, "List of roles successfully retrieved", $results);
    }

}