<?php

namespace App\Models\api\v1;

use Illuminate\Database\Eloquent\Model;

/**
 * @property integer $id
 * @property string $name
 * @property string $code
 * @property integer $is_active
 * @property string $created_at
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $updated_at
 * @property integer $is_deleted
 * @property string $deleted_at
 * @property integer $deleted_by
 * @property User[] $users
 */
class Gender extends Model
{
    /**
     * The "type" of the auto-incrementing ID.
     * 
     * @var string
     */
    protected $keyType = 'integer';

    /**
     * @var array
     */
    protected $fillable = ['name', 'uuid', 'is_active', 'created_at', 'created_by', 'updated_by', 'updated_at', 'is_deleted', 'deleted_at', 'deleted_by'];
    protected $hidden = ['created_at', 'created_by', 'updated_by', 'updated_at', 'is_deleted', 'deleted_at', 'deleted_by'];



    /**
     * Scope Active
     */
    public function scopeActive($query)
    {
        return $query->where('genders.is_active', '1');
    }



    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function users()
    {
        return $this->hasMany('App\Models\api\v1\User');
    }


    public static function GetGenderDetailsById(int $gender_id): array
    {
        $gender = Gender::find($gender_id);
        return [
            'id'        => $gender->id,
            'name'      => $gender->name,
            'uuid'      => $gender->uuid,
            'is_active' => $gender->is_active == 1
        ];
    }
}
