<?php


namespace App\Services;


use App\Constant\ConstantField;
use App\Models\api\v1\Order;
use App\Models\api\v1\Transaction;
use App\Models\api\v1\TransactionStatus;
use App\Models\api\v1\TransactionType;

class CinetPayService
{
    //Variable obligatoire identifiant
    private  $apikey = ConstantField::CINTEPAY_API_KEY;
    private $site_id = ConstantField::CINTEPAY_SITE_ID;
    private $channels = ConstantField::CINETPAY_CHANNEL;

    private $notify_url = ConstantField::CINETPAY_NOTIFY_URL;
    private $return_url = "";

    private $invoice_data = array(
        "Data 1" => "",
        "Data 2" => "",
        "Data 3" => ""
    );
    public $amount = null;
    protected $BASE_URL = null;


    private $currency = 'XOF';
    private $transaction_id = null;
    private $customer_name = null;
    private $customer_surname = null;
    private $description = null;

    //Toutes les variables
    private  $metadata = null;
    private  $alternative_currency = null;
    private  $customer_email = null;
    private  $customer_phone_number = null;
    private  $customer_address = null;
    private  $customer_city = null;
    private  $customer_country = null;
    private  $customer_state = null;
    private  $customer_zip_code = null;

    //variables des payments check
    private  $token = null;
    private  $chk_payment_date = null;
    private  $chk_operator_id = null;
    private  $chk_payment_method = null;
    private  $chk_code = null;
    private  $chk_message = null;
    private  $chk_api_response_id = null;
    private  $chk_description = null;
    private  $chk_amount = null;
    private  $chk_currency = null;
    private  $chk_metadata = null;
    private  $chk_status = null;


    /**
     * CinetPay constructor.
     * @param $site_id
     * @param $apikey
     * @param string $version
     * @param array $params
     */
    public function __construct($version = 'v2')
    {
        $this->BASE_URL = sprintf('https://api-checkout.cinetpay.com/%s/payment', strtolower($version));
        $this->apikey = ConstantField::CINTEPAY_API_KEY;
        $this->site_id = ConstantField::CINTEPAY_SITE_ID;
        $this->channels = "ALL";
    }

    //generer lien de payment
    public function generatePaymentLink($compte)
    {
        //champs facultatif
        if (!empty($compte['notify_url'])) $this->notify_url = ConstantField::CINETPAY_NOTIFY_URL;


        // On v&rifie les données.
        $this->CheckDataExist($compte, "payment");

        // On initialise champs obligatoire
        $this->return_url = $compte['return_url'];
        $this->amount = intval($compte['amount']);

        $this->description = $compte['description'];

        //champs quasi obligatoire
        $this->customer_name = $compte['name'];
        $this->customer_surname = $compte['name'];
        $this->transaction_id  = $compte['transaction_id'];


        //exception pour le CREDIT_CARD
        if ($this->channels == "CREDIT_CARD")
            $this->checkDataExist($compte, "paymentCard");

        if (!empty($compte['alternative_currency'])) $this->alternative_currency = "XOF";
        if (!empty($compte['customer_phone_number']))  $this->customer_phone_number = $compte['tel'];
        if (!empty($compte['customer_country']))    $this->customer_country = "Côte D'Ivoire";
        if (!empty($compte['customer_email']))  $this->customer_email = "";
        if (!empty($compte['customer_address']))  $this->customer_address = "";
        if (!empty($compte['customer_city']))  $this->customer_city = "";
        if (!empty($compte['customer_state']))  $this->customer_state = "";
        if (!empty($compte['customer_zip_code']))  $this->customer_zip_code = "";
        if (!empty($compte['metadata']))  $this->metadata = "";

        //customer data concatenate
        $customer_data = $this->customer_name . ' ' . $this->customer_email;
        $customer_data = $customer_data . ' ' . $this->amount . ' ' . $this->alternative_currency . ' ' .  $this->customer_phone_number;
        $customer_data = $customer_data . ' ' . $this->customer_country;
        // Formatage des données dans un tableau
        $data = $this->getData();
        // On génère l'URL de paiement
        $flux_json = $this->callCinetpayWsMethod($data, $this->BASE_URL);
        if ($flux_json == false)
            throw new \Exception("Un probleme est survenu lors de l'appel du WS !");

        $paymentUrl = json_decode($flux_json, true);
        $paymentUrl['request'] = $data;
        $paymentUrl["response"] = $flux_json;
        if (is_array($paymentUrl)) {
            if (empty($paymentUrl['data'])) {
                $message = 'Une erreur est survenue, Code: ' . $paymentUrl['code'] . ', Message: ' . $paymentUrl['message'] . ', Description: ' . $paymentUrl['description'];
                throw new \Exception($message);
            }
        }
        return $paymentUrl;
    }


    /*****
     * Processing CinetPay Callback
     */
    public function processingCallback($data, &$isOk = false)
    {
        $isOk = false;
        try {
            if ($data['cpm_site_id'] == ConstantField::CINTEPAY_SITE_ID) {
                $this->getPayStatus($data['cpm_trans_id'], ConstantField::CINTEPAY_SITE_ID);
                if (!empty($this->chk_status) && $this->chk_status == "ACCEPTED") {
                    $isOk = true;
                }
            }
        } catch (\Exception $e) {
            $isOk = false;
        }
    }

    //check data
    public function CheckDataExist($param, $action)
    {
        if (empty($this->apikey))
            throw new \Exception("Erreur: Apikey non defini");
        if (empty($this->site_id))
            throw new \Exception("Erreur: Site_id non defini");

        if (empty($param['transaction_id']))
            throw new \Exception('Veuillez renseigner la transaction Id');

        if (!empty($compte['return_url']))
            throw new \Exception('Veuillez renseigner l\'url de retour');


        if ($action == "payment") {
            if (empty($param['amount']))
                throw new \Exception("Erreur: Amount non defini");
            if (empty($param['description']))
                throw new \Exception("Erreur: Description non defini");
            if (empty($param['libelle']))
                throw new \Exception("Erreur: Libelle non defini");
        } elseif ($action == "paymentCard") {
            if (empty($param['customer_email']))
                throw new \Exception("Erreur: customer_email non defini (champs requis pour le paiement par carte)");
            if (empty($param['customer_phone_number']))
                throw new \Exception("Erreur: custom_phone_number non defini (champs requis pour le paiement par carte)");
            if (empty($param['customer_address']))
                throw new \Exception("Erreur: Customer_address non defini (champs requis pour le paiement par carte)");
            if (empty($param['customer_city']))
                throw new \Exception("Erreur: customer_city non defini (champs requis pour le paiement par carte)");
            if (empty($param['customer_country']))
                throw new \Exception("Erreur: customer_country non defini (champs requis pour le paiement par carte)");
            if (empty($param['customer_state']))
                throw new \Exception("Erreur: Customer_address non defini (champs requis pour le paiement par carte)");
            if (empty($param['customer_zip_code']))
                throw new \Exception("Erreur: customer_zip_code non defini (champs requis pour le paiement par carte)");
        }
    }

    //send datas
    private function callCinetpayWsMethod($params, $url, $method = 'POST')
    {

        if (function_exists('curl_version')) {
            try {
                $curl = curl_init();

                curl_setopt_array($curl, array(
                    CURLOPT_URL => $url,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 45,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => $method,
                    CURLOPT_POSTFIELDS => json_encode($params),
                    CURLOPT_SSL_VERIFYPEER => 0,
                    CURLOPT_HTTPHEADER => array(
                        "content-type:application/json"
                    ),
                ));
                $response = curl_exec($curl);
                $err = curl_error($curl);
                curl_close($curl);
                if ($err) {
                    throw new \Exception("Error :" . $err);
                } else {
                    return $response;
                }
            } catch (\Exception $e) {
                throw new \Exception($e);
            }
        } else {
            throw new \Exception("Vous devez activer curl ou allow_url_fopen pour utiliser CinetPay");
        }
    }

    //getData
    public function getData()
    {
        $dataArray = array(
            "amount" => $this->amount,
            "apikey" => ConstantField::CINTEPAY_API_KEY,
            "site_id" => ConstantField::CINTEPAY_SITE_ID,
            "currency" => $this->currency,
            "transaction_id" => $this->transaction_id,
            "customer_surname" => $this->customer_surname,
            "customer_name" => $this->customer_name,
            "description" => $this->description,
            "notify_url" => ConstantField::CINETPAY_NOTIFY_URL,
            "return_url" => $this->return_url,
            "channels" => $this->channels,
            "alternative_currency" => $this->alternative_currency,
            "invoice_data" => $this->invoice_data,
            "customer_email" => $this->customer_email,
            "customer_phone_number" => $this->customer_phone_number,
            "customer_address" => $this->customer_address,
            "customer_city" => $this->customer_city,
            "customer_country" => $this->customer_country,
            "customer_state" => $this->customer_state,
            "customer_zip_code" => $this->customer_zip_code,
            "metadata" => $this->metadata,
        );
        return $dataArray;
    }

    //get payStatus
    public function getPayStatus($id_transaction, $site_id)
    {
        $data = (array)$this->getPayStatusArray($id_transaction, $site_id);

        $flux_json = $this->callCinetpayWsMethod($data, $this->BASE_URL . "/check");


        if ($flux_json == false)
            throw new \Exception("Un probleme est survenu lors de l'appel du WS !");

        $statusPayment = json_decode($flux_json, true);

        if (is_array($statusPayment)) {
            if (empty($statusPayment['data'])) {
                $message = 'Une erreur est survenue, Code: ' . $statusPayment['code'] . ', Message: ' . $statusPayment['message'] . ', Description: ' . $statusPayment['description'];
                throw new \Exception($message);
            }
        }
        $this->chk_payment_date = $statusPayment['data']['payment_date'];
        $this->chk_operator_id = $statusPayment['data']['operator_id'];
        $this->chk_payment_method = $statusPayment['data']['payment_method'];
        $this->chk_amount = $statusPayment['data']['amount'];
        $this->chk_currency = $statusPayment['data']['currency'];
        $this->chk_code = $statusPayment['code'];
        $this->chk_message = $statusPayment['message'];
        $this->chk_api_response_id = $statusPayment['api_response_id'];
        $this->chk_description = $statusPayment['data']['description'];
        $this->chk_metadata = $statusPayment['data']['metadata'];
        $this->chk_status = $statusPayment['data']['status'];
    }

    private function getPayStatusArray($id_transaction, $site_id)
    {
        return array(
            'apikey' => $this->apikey,
            'site_id' => $site_id,
            'transaction_id' => $id_transaction
        );
    }
}
