<?php

namespace App\Services;


use App\Constant\OTPAction;
use App\Models\api\v1\ApiKey;
use App\Models\User;
use App\Constant\OTPStatus;
use App\Models\api\v1\MfaCode;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Log;
use Mediumart\Orange\SMS\Http\SMSClient;
use Mediumart\Orange\SMS\SMS;
use Symfony\Component\HttpFoundation\Request;

class CommonService
{
    /**
     * Create WsPost.
     */
    public static function wsPost($url, $data, $headers = [], &$statusCode = 300, &$isOk = false)
    {
        $isOk = false;
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        # Request headers
        if (!empty($headers)) {
            curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        }
        # Request body
        $request_body = json_encode($data);

        curl_setopt($curl, CURLOPT_POSTFIELDS, $request_body);
        $result     = curl_exec($curl);
        $statusCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        // $info = curl_getinfo($curl);
        // print_r(json_encode($info));
        curl_close($curl);
        $isOk       = true;
        return  $result;
    }

    /**
     * Create WsPut.
     */
    public static function wsPut($url, $data, $headers = [], &$statusCode = 300, &$isOk = false)
    {
        $isOk = false;
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        # Request headers
        if (!empty($headers)) {
            curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        }
        # Request body
        $request_body = json_encode($data);

        curl_setopt($curl, CURLOPT_POSTFIELDS, $request_body);
        $result     = curl_exec($curl);
        $statusCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        // $info = curl_getinfo($curl);
        // print_r(json_encode($info));
        curl_close($curl);
        $isOk       = true;
        return  $result;
    }

    /**
     * @return void
     */
    public static function wsGet($url, $headers = [], &$statusCode = 300)
    {

        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        if (!empty($headers)) {
            curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        }
        //for debug only!
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

        $resp = curl_exec($curl);
        $statusCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
        // $resp = intval($resp);
        return $resp;
    }
}
