<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('providers_by_country', function (Blueprint $table) {
            $table->foreign(['country_id'], 'pbc_country')->references(['id'])->on('countries')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign(['provider_id'], 'pby_provider')->references(['id'])->on('providers')->onUpdate('CASCADE')->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('providers_by_country', function (Blueprint $table) {
            $table->dropForeign('pbc_country');
            $table->dropForeign('pby_provider');
        });
    }
};
