


INSERT INTO `countries` (`id`, `name`, `uuid`, `is_active`, `created_at`, `created_by`, `updated_by`, `updated_at`, `is_deleted`, `deleted_at`, `deleted_by`) VALUES
(1, 'Cote d Ivoire', 'a', 1, '2023-12-22 17:44:39', 1, NULL, '2023-12-22 17:44:39', 0, NULL, NULL);

-- --------------------------------------------------------

--

INSERT INTO `countries_payment_modes` (`id`, `country_id`, `payment_mode_id`, `is_active`, `created_at`, `created_by`, `updated_by`, `updated_at`, `is_deleted`, `deleted_at`, `deleted_by`) VALUES
(1, 1, 2, 1, '2023-12-24 17:49:08', 1, NULL, '2023-12-24 17:49:08', 0, NULL, NULL),
(2, 1, 1, 1, '2023-12-24 17:49:08', 1, NULL, '2023-12-24 17:49:08', 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Déchargement des données de la table `items`
--

INSERT INTO `items` (`id`, `uuid`, `size`, `unit`, `name`, `description`, `img_1`, `provider_by_country_id`, `is_active`, `created_at`, `created_by`, `updated_by`, `updated_at`, `is_deleted`, `deleted_at`, `deleted_by`) VALUES
(2, 'AAAA', '33', 'CL', 'Coca-Cola', 'Boisson gazeuse', NULL, 1, 1, '2023-12-24 20:08:33', 1, NULL, '2023-12-24 20:08:33', 0, NULL, NULL),
(3, 'BBB', '33', 'CL', 'Fanta', 'Boisson gazeuse', NULL, 1, 1, '2023-12-24 20:08:33', 1, NULL, '2023-12-24 20:08:33', 0, NULL, NULL),
(4, 'CCC', '33', 'CL', 'Nutella', 'Pate à tartiner', NULL, 2, 1, '2023-12-24 20:08:33', 1, NULL, '2023-12-24 20:08:33', 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Déchargement des données de la table `migrations`
--

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(1, '2016_06_01_000001_create_oauth_auth_codes_table', 1),
(2, '2016_06_01_000002_create_oauth_access_tokens_table', 1),
(3, '2016_06_01_000003_create_oauth_refresh_tokens_table', 1),
(4, '2016_06_01_000004_create_oauth_clients_table', 1),
(5, '2016_06_01_000005_create_oauth_personal_access_clients_table', 1),
(6, '2019_12_14_000001_create_personal_access_tokens_table', 1),
(7, '2023_12_19_073619_create_country_table', 1),
(8, '2023_12_22_073802_create_countries_table', 0),
(9, '2023_12_22_073802_create_country_table', 0),
(10, '2023_12_22_073802_create_oauth_access_tokens_table', 0),
(11, '2023_12_22_073802_create_oauth_auth_codes_table', 0),
(12, '2023_12_22_073802_create_oauth_clients_table', 0),
(13, '2023_12_22_073802_create_oauth_personal_access_clients_table', 0),
(14, '2023_12_22_073802_create_oauth_refresh_tokens_table', 0),
(15, '2023_12_22_073802_create_order_statuses_table', 0),
(16, '2023_12_22_073802_create_payment_modes_table', 0),
(17, '2023_12_22_073802_create_personal_access_tokens_table', 0),
(18, '2023_12_22_073802_create_providers_table', 0),
(19, '2023_12_22_073802_create_providers_by_country_table', 0),
(20, '2023_12_22_073802_create_roles_table', 0),
(21, '2023_12_22_073802_create_spaces_table', 0),
(22, '2023_12_22_073802_create_subcription_statuses_table', 0),
(23, '2023_12_22_073802_create_subcription_types_table', 0),
(24, '2023_12_22_073802_create_transaction_statuses_table', 0),
(25, '2023_12_22_073802_create_transaction_types_table', 0),
(26, '2023_12_22_073802_create_users_table', 0);

-- --------------------------------------------------------


--
-- Déchargement des données de la table `oauth_access_tokens`
--

INSERT INTO `oauth_access_tokens` (`id`, `user_id`, `client_id`, `name`, `scopes`, `revoked`, `created_at`, `updated_at`, `expires_at`) VALUES
('14da96feb719e0e6061ffea1204e37985b59400a7b8484ecbfd58439081bf02c0ea1397b7f56c77e', 1, 1, 'AMCAuthApp', '[]', 0, '2023-12-25 10:59:35', '2023-12-25 10:59:35', '2023-12-26 11:59:35'),
('25c421926db5049290e1ce255fe9bcc749c1fe7035a60d9fbf5662dedc460d2e0743a4b9a43eb98e', 1, 1, 'AMCAuthApp', '[]', 0, '2023-12-25 09:00:53', '2023-12-25 09:00:53', '2023-12-26 10:00:53'),
('58405030b322900aea0a4a365a467715d725daecbf38bdacabac77b8d78d7033b20494d35723b686', 1, 1, 'AMCAuthApp', '[]', 0, '2023-12-25 20:49:28', '2023-12-25 20:49:28', '2023-12-26 21:49:28');

-- --------------------------------------------------------

--
-- Structure de la table `oauth_auth_codes`
--

--
-- Déchargement des données de la table `oauth_clients`
--

INSERT INTO `oauth_clients` (`id`, `user_id`, `name`, `secret`, `provider`, `redirect`, `personal_access_client`, `password_client`, `revoked`, `created_at`, `updated_at`) VALUES
(1, NULL, 'AmcBack Personal Access Client', 'tuXnBRvQxPac4tVsH2MHGRw8x0uMgB60UqMxuuee', NULL, 'http://localhost', 1, 0, 0, '2023-12-21 18:39:21', '2023-12-21 18:39:21'),
(2, NULL, 'AmcBack Password Grant Client', 'BeVgjDWXpfMZ5KfpttFey7S5tPwCqWrThXHAzBSq', 'users', 'http://localhost', 0, 1, 0, '2023-12-21 18:39:21', '2023-12-21 18:39:21');

-- --------------------------------------------------------


--
-- Déchargement des données de la table `oauth_personal_access_clients`
--

INSERT INTO `oauth_personal_access_clients` (`id`, `client_id`, `created_at`, `updated_at`) VALUES
(1, 1, '2023-12-21 18:39:21', '2023-12-21 18:39:21');

-- --------------------------------------------------------

--
-- Déchargement des données de la table `payment_modes`
--

INSERT INTO `payment_modes` (`id`, `name`, `is_active`, `created_at`, `created_by`, `updated_by`, `updated_at`, `is_deleted`, `deleted_at`, `deleted_by`) VALUES
(1, 'cash', 1, '2023-12-21 21:47:08', 1, NULL, '2023-12-21 21:47:08', 0, NULL, NULL),
(2, 'flex', 1, '2023-12-21 21:47:16', 1, NULL, '2023-12-21 21:47:16', 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `personal_access_tokens`
--
--
-- Déchargement des données de la table `providers`
--

INSERT INTO `providers` (`id`, `code`, `name`, `is_active`, `created_at`, `created_by`, `updated_by`, `updated_at`, `is_deleted`, `deleted_at`, `deleted_by`) VALUES
(1, 'a', 'solibra', 1, '2023-12-21 21:44:31', 1, NULL, '2023-12-21 21:44:31', 0, NULL, NULL),
(2, 'BB', 'Prosuma', 1, '2023-12-21 21:44:31', 1, NULL, '2023-12-21 21:44:31', 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `providers_by_country`
--
-- Déchargement des données de la table `providers_by_country`
--

INSERT INTO `providers_by_country` (`id`, `country_id`, `provider_id`, `is_active`, `created_at`, `created_by`, `updated_by`, `updated_at`, `is_deleted`, `deleted_at`, `deleted_by`) VALUES
(1, 1, 1, 1, '2023-12-24 20:07:18', 1, NULL, '2023-12-24 20:07:18', 0, NULL, NULL),
(2, 1, 2, 1, '2023-12-24 20:07:18', 1, NULL, '2023-12-24 20:07:18', 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `roles`

-- Déchargement des données de la table `roles`
--

INSERT INTO `roles` (`id`, `name`, `is_active`, `created_at`, `created_by`, `updated_by`, `updated_at`, `is_deleted`, `deleted_at`, `deleted_by`) VALUES
(1, 'user', 1, '2023-12-23 20:26:40', 1, NULL, '2023-12-23 20:26:40', 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `spaces`
--


--
-- Déchargement des données de la table `spaces`
--

INSERT INTO `spaces` (`id`, `uuid`, `code`, `name`, `address1`, `address2`, `lat`, `lng`, `neighborhood`, `municipality`, `city`, `country_id`, `is_active`, `created_at`, `created_by`, `updated_by`, `updated_at`, `is_deleted`, `deleted_at`, `deleted_by`) VALUES
(1, '8ab3e74a-68a0-4bf9-90cb-7f0981a30274', '', 'maquis 225', 'arcory remblais', NULL, 9.999999, 8.8888888, 'remblais', 'marcory', 'abidjan', 1, 1, '2023-12-21 21:43:14', 1, NULL, '2023-12-21 21:43:14', 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `stocks`
--


--
-- Déchargement des données de la table `stocks`
--

INSERT INTO `stocks` (`id`, `item_id`, `space_id`, `price`, `off_by_percentage`, `off_by_number`, `quantity`, `price_after_sale`, `is_active`, `created_at`, `created_by`, `updated_by`, `updated_at`, `is_deleted`, `deleted_at`, `deleted_by`) VALUES
(1, 2, 1, 200, NULL, NULL, 4, 200.00, 1, '2023-12-24 20:14:20', 1, NULL, '2023-12-24 20:14:20', 0, NULL, NULL),
(2, 3, 1, 300, NULL, 2.00, 3, 150.00, 1, '2023-12-24 20:14:20', 1, NULL, '2023-12-24 20:14:20', 0, NULL, NULL);



-- --------------------------------------------------------

--
-- Structure de la table `users`
--

INSERT INTO `users` (`id`, `uuid`, `gender_id`, `username`, `password`, `email`, `email_verified_at`, `remember_token`, `create_time`, `lastname`, `firstname`, `phone_code`, `country_id`, `is_active`, `created_at`, `created_by`, `updated_by`, `updated_at`, `is_deleted`, `deleted_at`, `deleted_by`) VALUES
(1, '8ab3e74a-68a0-4bf9-90cb-7f0981a30274', 2, '0709887766', '$2y$10$6IDw074qC/AoSSzotkEg.erfDmyBdDP3DiuljCkW.Xur13rzbToGa', NULL, NULL, NULL, '2023-12-24 11:39:37', 'Toure', 'Al Badra', '+225', 1, 1, '2023-12-24 11:39:37', NULL, NULL, '2023-12-25 20:53:23', 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `users_roles`
--



INSERT INTO `users_roles` (`id`, `user_id`, `role_id`, `creation_date`, `is_active`, `created_at`, `created_by`, `updated_by`, `updated_at`, `is_deleted`, `deleted_at`, `deleted_by`) VALUES
(1, 1, 1, '2023-12-24 11:39:37', 0, '2023-12-24 11:39:37', NULL, NULL, '2023-12-24 11:39:37', 0, NULL, NULL);

-- --------------------------------------------------------



--
-- Contraintes pour la table `countries_payment_modes`
--
ALTER TABLE `countries_payment_modes`
  ADD CONSTRAINT `cpm_country` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `cpm_payment` FOREIGN KEY (`payment_mode_id`) REFERENCES `payment_modes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `items`
--
ALTER TABLE `items`
  ADD CONSTRAINT `items_pbc` FOREIGN KEY (`provider_by_country_id`) REFERENCES `providers_by_country` (`id`);

--
-- Contraintes pour la table `line_items`
--
ALTER TABLE `line_items`
  ADD CONSTRAINT `li_order` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `li_stock` FOREIGN KEY (`stock_id`) REFERENCES `stocks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `orders`
--
ALTER TABLE `orders`
  ADD CONSTRAINT `order_server` FOREIGN KEY (`server_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `providers_by_country`
--
ALTER TABLE `providers_by_country`
  ADD CONSTRAINT `pbc_country` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `pby_provider` FOREIGN KEY (`provider_id`) REFERENCES `providers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `spaces`
--
ALTER TABLE `spaces`
  ADD CONSTRAINT `space_country` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `stocks`
--
ALTER TABLE `stocks`
  ADD CONSTRAINT `stock_item` FOREIGN KEY (`item_id`) REFERENCES `items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `stock_space` FOREIGN KEY (`space_id`) REFERENCES `spaces` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `subscriptions`
--
ALTER TABLE `subscriptions`
  ADD CONSTRAINT `sub_sb_status` FOREIGN KEY (`susbcription_status_id`) REFERENCES `subscription_statuses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `sub_sb_typ` FOREIGN KEY (`susbcription_type_id`) REFERENCES `subscription_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `subscription_types`
--
ALTER TABLE `subscription_types`
  ADD CONSTRAINT `st_country` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `transactions`
--
ALTER TABLE `transactions`
  ADD CONSTRAINT `trans_order` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `trans_status` FOREIGN KEY (`transaction_status_id`) REFERENCES `transaction_statuses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `trans_subscrip` FOREIGN KEY (`subscription_id`) REFERENCES `subscriptions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `trans_trans_type` FOREIGN KEY (`transaction_type_id`) REFERENCES `transaction_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `users`
--
ALTER TABLE `users`
  ADD CONSTRAINT `user_gender` FOREIGN KEY (`gender_id`) REFERENCES `genders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `users_type` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `users_roles`
--
ALTER TABLE `users_roles`
  ADD CONSTRAINT `ur_roles` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `ur_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `wallets`
--
ALTER TABLE `wallets`
  ADD CONSTRAINT `wallets_cp` FOREIGN KEY (`country_payment_mode_id`) REFERENCES `countries_payment_modes` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `wallets_users` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON UPDATE CASCADE;
COMMIT;

