<?php

use App\Models\Partenaires;
use App\Services\OtpService;

use Illuminate\Http\Request;
use App\Helpers\NotificationHelpers;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\TwoFAController;
use App\Http\Controllers\api\v1\AdsController;
use App\Http\Controllers\api\v1\UriController;
use \App\Http\Controllers\api\v1\MFAController;
use App\Http\Controllers\api\v1\ItemController;
use \App\Http\Controllers\api\v1\RoleController;
use App\Http\Controllers\api\v1\OrderController;
use App\Http\Controllers\api\v1\SpaceController;
use App\Http\Controllers\api\v1\StockController;
use App\Http\Controllers\api\v1\CartesController;
use App\Http\Controllers\NotificationsController;
use App\Http\Controllers\api\v1\AccountController;
use App\Http\Controllers\api\v1\HotSpotController;
use \App\Http\Controllers\api\v1\TransactionController;
use App\Http\Controllers\api\v1\SubscriptionController;
use App\Services\PushNotificationService;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/
// api ping
Route::get('/ping', function (Request $request)
{
    return "I am alive...";
});

Route::post('/send/notif/test', function (Request $request) {
    $devicetoken = $request->devicetoken;
    $title = $request->title;
    $body = $request->body;
    $otp = NotificationHelpers::send(
        [$devicetoken],
        $title,
        $body,
        []
    );
    return $otp;
});

route::post('/callback/cinetpay', [TransactionController::class, 'processingCallbackCinetPay'])->name('CALLBACK_CINETPAY');


Route::get('/callback/cinetpay', function (Request $request) {
    return response()->json(['success' => true, "message" => "I am alive..."]);
});



route::get('/spaces/qrcode/{space_qrcode}', [SpaceController::class, 'getSpaceByQrCode'])->name('GET_SPACE_BY_QRCODE');
route::get('/spaces/{space_uuid}/stocks',[SpaceController::class, 'showStock'])->name('SPACE_ITEMS_LIST'); //recuperer liste article espace 

//prefixage api key
Route::middleware(['with_fast_api_key','check_device'])->group(function ()
{
    //well-known-uri
//    Route::get('/well-known-uri', function (Request $request)
//    {
//        return response()->json(['success' => true, 'message' =>  '', 'data' => [
//                "LOGIN" => env('APP_URL').'/api/login-i0s11' , "REGISTRATION" => env('APP_URL').'/api/users/create' ]]);
//
//    });
     Route::get('/well-known-uri', [UriController::class, 'well_known_uri'])->name('WELL_KNOW_URI');
     
     Route::get('/ads/{type}', [AdsController::class, 'getAds'])->name('GET_ADS');

     // LOGIN
    route::post('/login', [UserController::class, 'login'])->name('LOGIN');

    // REGISTER USER
    route::post('/registration', [UserController::class, 'userCreate'])->name('REGISTRATION');
    route::post('/users/create', [UserController::class, 'userCreate'])->name('REGISTRATION');

    Route::prefix('roles')->group(function ()
    {
        route::get('/', [RoleController::class, 'list'])->name('ROLES_LIST'); //recuperer liste des role
    });

    // MFA
    Route::prefix('mfa')->group(function ()
    {
        route::post('/generate-send-code', [MFAController::class, 'generateSendCode'])->name('GENERATE_SEND_CODE');
        route::post('/verify-code', [MFAController::class, 'verifyCode'])->name('VERIFY_CODE');
    });

    // USERS
    Route::prefix('users')->middleware('auth:api')->group(function ()
    {
        route::put('/phone-number', [UserController::class, 'updatePhoneNumber'])->name('UPDATE_USER_PHONE_NUMBER');
        route::put('/profile', [UserController::class, 'userUpdateProfile'])->name('UPDATE_USER_PROFILE');
        route::put('/password', [UserController::class, 'updatePassword'])->name('UPDATE_USER_PASSWORD');
        route::put('/roles', [UserController::class, 'updateRoles'])->name('UPDATE_ROLES');
        route::put('/device-token', [UserController::class, 'updateDeviceToken'])->name('UPDATE_DEVICE_TOKEN');
        route::get('/details', [UserController::class, 'details'])->name('USER_DETAILS');
        route::post('logout', [UserController::class, 'logout'])->name('USER_LOGOUT');
        route::delete('account', [UserController::class, 'deleteAccount'])->name('DELETE_USER_ACCOUNT');
        route::get('/orders/qrcode/{num_card}/{space_uuid}', [OrderController::class, 'getClientByQrCode'])->name('GET_CLIENT_BY_QRCODE');
        route::get('/transactions', [TransactionController::class, 'list'])->name('USER_LIST_TRANSACTIONS');
        route::get('/{token}/details', [TransactionController::class, 'userDetails'])->name('USER_DETAILS_BY_TOKEN');
        route::get('/orders', [OrderController::class, 'userOrders'])->name('USER_ORDER_LIST');
        route::get('/orders/payment/online', [OrderController::class, 'generatePaymentOnlineLink'])->name('PAYMENT_ONLINE_LINK');
        route::get('/orders/with-space', [OrderController::class, 'userOrdersWithSpace'])->name('USER_ORDER_LIST_WITH_SPACE');
        route::get('/orders/{order_uuid}', [OrderController::class, 'show'])->name('USER_ORDER_DETAIL');
        Route::post('/orders', [OrderController::class, 'create'])->name('USER_CREATE_ORDER');
        Route::put('/orders/{uuid}', [OrderController::class, 'update'])->name('USER_ORDER_UPDATE');
        Route::put('/orders/{uuid}/line-items', [OrderController::class, 'updateOrderLineItem'])
            ->name('USER_UPDATE_ORDER_LINE_ITEM');
        Route::put('/orders/{uuid}/{status}', [OrderController::class, 'changeStatus'])->name('ORDER_CHANGE_STATUS');

    });

    // SPACES
    Route::prefix('spaces')->middleware('auth:api')->controller(SpaceController::class)->group(function ()
    {
        route::get('/{space_uuid}', 'show')->name('SPACE_DETAILS'); //recuperer detail espace
        route::post('/{space_uuid}/assign-user', 'assignUserToSpace')->name('ASSIGN_USER_TO_SPACE'); 
        route::post('/{space_uuid}/waiters', 'createWaiter')->name('CREATE_WAITER_TO_SPACE');
        route::delete('/{space_uuid}/waiters', 'deleteWaiterBySpace')->name('DELETE_WAITER_TO_SPACE');
		route::get('/{space_uuid}/waiters', 'getListWaiters')->name('GET_WAITERS_FROM_SPACE');
		route::get('/ssid/{space_ssid}','getSpaceBySssid')->name('GET_SPACE_BY_SSID'); // @TODO implement after
		 // @TODO implement after
    });

    Route::put('spaces/orders/{uuid}',[OrderController::class, 'update'])->middleware('auth:api')->name('SPACE_ORDER_UPDATE');
    Route::put('spaces/{space_uuid}/orders/{uuid}',[OrderController::class, 'updateSpace'])
        ->middleware('auth:api')->name('SPACE_ORDER_UPDATE');
    Route::get('spaces/{space_uuid}/orders/',   [OrderController::class, 'spaceOrders'])->middleware('auth:api')->name('SPACE_ORDERS');
    Route::get('spaces/{space_uuid}/orders/{order_uuid}',   [OrderController::class, 'show_space'])->middleware('auth:api')->name('SPACE_ORDERS');
    Route::get('spaces/{space_uuid}/orders-list',   [OrderController::class, 'OrderToSpace'])->middleware('auth:api')->name('SPACE_ORDERS_LIST_BY_STATUS');
    Route::put('spaces/{space_uuid}/orders/{order_uuid}/line-items',   [OrderController::class, 'updateOrderLineItemSpace'])
        ->middleware('auth:api')->name('SPACE_UPDATE_ORDER_LINE_ITEM');

	Route::put('spaces/{space_uuid}/orders/{order_uuid}/assign', [OrderController::class, 'assignOrderToWaiter'])->middleware('auth:api')->name('WAITER_ORDERS');
    Route::put('spaces/{space_uuid}/orders/{order_uuid}/waiter/{waiter_uuid}', [OrderController::class, 'assignOrderToWaiter'])->middleware('auth:api')->name('WAITER_ORDERS_UPDATE');
    Route::get('spaces/{space_uuid}/waiters/{waiter_uuid}/orders', [OrderController::class, 'OrderToWaiter'])->middleware('auth:api')->name('WAITER_ORDERS_LIST');

    // SUBSCRIPTIONS
    Route::prefix('subscriptions')->middleware('auth:api')->controller(SubscriptionController::class)->group(function ()
    {
        route::get('/types-list', 'subscriptionTypes')->name('SUBSCRIPTION_TYPES');
        route::get('/list','subcriptionsHistory')->name('USER_SUBSCRIPTIONS');
        route::get('/{id}', 'details')->name('SUBSCRIPTION_DETAILS');
        route::post('/enroll', 'enroll')->name('SUBSCRIPTION_ENROLLMENT');

    });


    // TRANSACTIONS
    Route::prefix('transactions')->middleware('auth:api')->controller(OrderController::class)->group(function ()
    {
        route::get('/{id}', 'details')->name('TRANSACTIONS_DETAILS');

    });

    // WALLETS
    Route::prefix('wallets')->middleware('auth:api')->controller(AccountController::class)->group(function ()
    {
        route::get('/', 'walletsInfo')->name('WALLETS_DETAILS');
        route::post('/fund-by-bank', 'fundByBank')->name('FUND_WALLET_BY_BANK');
        route::post('/fund-by-mobile-money', 'fundByMobileMoney')->name('FUND_WALLET_BY_MOBILE_MONEY');
    });

    // ORDERS
    Route::prefix('orders')->middleware('auth:api')->controller(OrderController::class)->group(function ()
    {
        Route::get('/list','index')->name('ORDER_LIST');
        Route::get('/statuses','getstatuses')->name('ORDER_STATUSES_LIST');
        Route::get('/{uuid}','show')->name('ORDER_DETAILS');
        Route::put('/{uuid}','update')->name('ORDER_UPDATE');
        Route::put('/{uuid}/line-items','updateItem')->name('ORDER_UPDATE_ITEM');
        Route::put('/{uuid}/{status}','changeStatus')->name('ORDER_CHANGE_STATUS');
        Route::delete('/{uuid}','deleteOrder')->name('DELETE_ORDER');
		
		Route::put('/{uuid}/assign', 'assignOrderToWaiter')->name('WAITER_ORDERS');

    });

    // STOCKS
    Route::prefix('stocks')->middleware('auth:api')->controller(StockController::class)->group(function ()
    {
        Route::post('/','create')->name('ADD_STOCK');
        Route::get('/{uuid}','show')->name('SHOW_STOCK');
        Route::delete('/{stock_id}','deleteStock')->name('DELETE_STOCK'); // @TODO implement after
    });

    // STOCKS
    Route::prefix('items')->middleware('auth:api')->controller(ItemController::class)->group(function ()
    {
        Route::get('/','list')->name('GET_ITEMS');
        Route::post('/','add')->name('ADD_ITEM');
        Route::get('/{sapce_uuid}/promotion','getPromotionItemBySpace')->name('GET_ITEMS_PROMOTION_BY_SPACE');
        Route::get('/{uuid}/{user_role_name}','show')->name('SHOW_ITEM');
        Route::put('/{uuid}','update')->name('UPDATE_ITEM');
        Route::delete('/{uuid}','delete')->name('DELETE_ITEM');
    });


    Route::prefix('hotspot')->middleware('auth:api')->controller(HotSpotController::class)->group(function()
    {
        Route::post('/login', 'login')->name('HOTSPOT_LOGIN');
        Route::post('/payment', 'customerRecharge')->name('HOTSPOT_PAYMENT');
        Route::post('/remaining-time', 'remainingTime')->name('HOTSPOT_REMAINING_TIME');
        Route::post('/offers', 'listOfOffers')->name('HOTSPOT_LIST_OF_OFFERS');
        //Route::post('/recharge', 'customerRecharge')->name('HOTSPOT_CUSTOMER_RECHARGE');
        Route::post('/recharge/list', 'customerRefills')->name('HOTSPOT_CUSTOMER_REFILLS_LIST');
        Route::post('/create/customer', 'createCustomer')->name('HOTSPOT_CREATE_CUSTOMER');
    });

    Route::prefix('ads')->middleware('auth:api')->controller(AdsController::class)->group(function()
    {
        Route::get('/', 'getAds')->name('ADS_GET');
    });
	
});

Route::controller(CartesController::class)->group(function ()
{
    Route::get('/getpartenairefromcarteid', 'getpartenairefromcarteid');
});